<?php
include('includes/dbconnection.php');

// Check if table exists
$check_table = mysqli_query($con, "SHOW TABLES LIKE 'tblslider'");
if(mysqli_num_rows($check_table) == 0) {
    echo "Table tblslider does not exist. Creating it...\n";
    
    // Create the table
    $create_table = "CREATE TABLE `tblslider` (
      `ID` int(11) NOT NULL AUTO_INCREMENT,
      `SliderTitle` varchar(255) NOT NULL,
      `SliderImage` varchar(255) NOT NULL,
      `SliderDescription` text DEFAULT NULL,
      `SliderLink` varchar(255) DEFAULT NULL,
      `SliderOrder` int(11) DEFAULT 1,
      `Status` int(11) DEFAULT 1,
      `CreationDate` timestamp NOT NULL DEFAULT current_timestamp(),
      PRIMARY KEY (`ID`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    if(mysqli_query($con, $create_table)) {
        echo "Table tblslider created successfully!\n";
        
        // Insert sample data
        $insert_sample = "INSERT INTO `tblslider` (`SliderTitle`, `SliderImage`, `SliderDescription`, `SliderLink`, `SliderOrder`, `Status`) VALUES
        ('Apple iPhone Collection', 'apple_slider_1.svg', 'Discover the latest iPhone models with cutting-edge technology', 'shop-mobile.php', 1, 1),
        ('Apple Watch Series', 'apple_slider_2.svg', 'Complete your Apple experience with premium accessories', 'shop-mobile.php', 2, 1)";
        
        if(mysqli_query($con, $insert_sample)) {
            echo "Sample data inserted successfully!\n";
        } else {
            echo "Error inserting sample data: " . mysqli_error($con) . "\n";
        }
    } else {
        echo "Error creating table: " . mysqli_error($con) . "\n";
    }
} else {
    echo "Table tblslider already exists. Checking structure...\n";
    
    // Check table structure
    $describe = mysqli_query($con, "DESCRIBE tblslider");
    echo "Table structure:\n";
    while($row = mysqli_fetch_assoc($describe)) {
        echo "- " . $row['Field'] . " (" . $row['Type'] . ")\n";
    }
}

mysqli_close($con);
?>