<?php
include('includes/dbconnection.php');

echo "<h2>Force Recreate Slider Table</h2>";

// Drop table if exists
echo "<p>Dropping existing tblslider table if it exists...</p>";
$drop_result = mysqli_query($con, "DROP TABLE IF EXISTS tblslider");
if ($drop_result) {
    echo "<p style='color: green;'>Table dropped successfully (or didn't exist)</p>";
} else {
    echo "<p style='color: red;'>Error dropping table: " . mysqli_error($con) . "</p>";
}

// Create new table
echo "<p>Creating new tblslider table...</p>";
$create_sql = "CREATE TABLE `tblslider` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SliderTitle` varchar(255) NOT NULL,
  `SliderImage` varchar(255) NOT NULL,
  `SliderDescription` text DEFAULT NULL,
  `SliderLink` varchar(255) DEFAULT NULL,
  `SliderOrder` int(11) DEFAULT 1,
  `Status` int(11) DEFAULT 1,
  `CreationDate` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

if (mysqli_query($con, $create_sql)) {
    echo "<p style='color: green;'>Table created successfully!</p>";
    
    // Verify table structure
    echo "<h3>Verifying table structure:</h3>";
    $describe = mysqli_query($con, "DESCRIBE tblslider");
    if ($describe) {
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        while ($row = mysqli_fetch_assoc($describe)) {
            echo "<tr>";
            echo "<td>" . $row['Field'] . "</td>";
            echo "<td>" . $row['Type'] . "</td>";
            echo "<td>" . $row['Null'] . "</td>";
            echo "<td>" . $row['Key'] . "</td>";
            echo "<td>" . $row['Default'] . "</td>";
            echo "<td>" . $row['Extra'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // Insert sample data
    echo "<p>Inserting sample data...</p>";
    $insert_sql = "INSERT INTO `tblslider` (`SliderTitle`, `SliderImage`, `SliderDescription`, `SliderLink`, `SliderOrder`, `Status`) VALUES
    ('Apple iPhone Collection', 'apple_slider_1.svg', 'Discover the latest iPhone models with cutting-edge technology', 'shop-mobile.php', 1, 1),
    ('Apple Watch Series', 'apple_slider_2.svg', 'Complete your Apple experience with premium accessories', 'shop-mobile.php', 2, 1)";
    
    if (mysqli_query($con, $insert_sql)) {
        echo "<p style='color: green;'>Sample data inserted successfully!</p>";
        
        // Verify data
        $count = mysqli_query($con, "SELECT COUNT(*) as total FROM tblslider");
        $total = mysqli_fetch_assoc($count)['total'];
        echo "<p>Total records: <strong>$total</strong></p>";
        
        echo "<h4>Sample records:</h4>";
        $sample = mysqli_query($con, "SELECT * FROM tblslider LIMIT 3");
        if (mysqli_num_rows($sample) > 0) {
            echo "<table border='1' style='border-collapse: collapse;'>";
            echo "<tr><th>ID</th><th>SliderTitle</th><th>SliderImage</th><th>SliderDescription</th><th>Status</th></tr>";
            while ($row = mysqli_fetch_assoc($sample)) {
                echo "<tr>";
                echo "<td>" . $row['ID'] . "</td>";
                echo "<td>" . $row['SliderTitle'] . "</td>";
                echo "<td>" . $row['SliderImage'] . "</td>";
                echo "<td>" . substr($row['SliderDescription'], 0, 50) . "...</td>";
                echo "<td>" . $row['Status'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
        
    } else {
        echo "<p style='color: red;'>Error inserting sample data: " . mysqli_error($con) . "</p>";
    }
    
} else {
    echo "<p style='color: red;'>Error creating table: " . mysqli_error($con) . "</p>";
}

echo "<hr>";
echo "<p><strong>Table recreation complete!</strong></p>";
echo "<p><a href='add-slider.php'>Test Add Slider</a> | <a href='manage-slider.php'>Manage Sliders</a></p>";

mysqli_close($con);
?>