<?php
include('includes/dbconnection.php');

echo "<h2>Slider Database Data:</h2>";

$query = mysqli_query($con, "SELECT * FROM tblslider ORDER BY SliderOrder ASC, CreationDate DESC");

if(mysqli_num_rows($query) > 0) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>ID</th><th>Title</th><th>Image</th><th>Description</th><th>Link</th><th>Order</th><th>Status</th><th>Creation Date</th></tr>";
    
    while($row = mysqli_fetch_array($query)) {
        echo "<tr>";
        echo "<td>" . $row['ID'] . "</td>";
        echo "<td>" . htmlspecialchars($row['SliderTitle']) . "</td>";
        echo "<td>" . htmlspecialchars($row['SliderImage']) . "</td>";
        echo "<td>" . htmlspecialchars($row['SliderDescription']) . "</td>";
        echo "<td>" . htmlspecialchars($row['SliderLink']) . "</td>";
        echo "<td>" . $row['SliderOrder'] . "</td>";
        echo "<td>" . $row['Status'] . "</td>";
        echo "<td>" . $row['CreationDate'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<h3>Image Path Check:</h3>";
    $query2 = mysqli_query($con, "SELECT SliderImage FROM tblslider WHERE Status='1' LIMIT 1");
    if($row2 = mysqli_fetch_array($query2)) {
        $image_name = $row2['SliderImage'];
        echo "<p>Sample image name: " . $image_name . "</p>";
        echo "<p>Current path in code: admin/slider-images/" . $image_name . "</p>";
        echo "<p>Actual path should be: admin/images/slider/" . $image_name . "</p>";
        
        // Check if file exists
        $correct_path = "admin/images/slider/" . $image_name;
        $wrong_path = "admin/slider-images/" . $image_name;
        
        echo "<p>File exists at correct path: " . (file_exists($correct_path) ? "YES" : "NO") . "</p>";
        echo "<p>File exists at wrong path: " . (file_exists($wrong_path) ? "YES" : "NO") . "</p>";
    }
} else {
    echo "<p>No slider data found in database.</p>";
}
?>