<?php
session_start();
error_reporting(0);
include('includes/dbconnection.php');
// Password reset is now handled via AJAX with OTP verification
?>
<!DOCTYPE html>
<html lang="zxx">
<head>
    <title>Mobile Store Management System | Forgot Password</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
   
    <!-- Vendor CSS Files -->
    <link rel="stylesheet" href="assets/css/vendor/jquery-ui.min.css">
    <link rel="stylesheet" href="assets/css/vendor/fontawesome.css">
    <link rel="stylesheet" href="assets/css/vendor/plaza-icon.css">
    <link rel="stylesheet" href="assets/css/vendor/bootstrap.min.css">

    <!-- Plugin CSS Files -->
    <link rel="stylesheet" href="assets/css/plugin/swiper.min.css">
    <link rel="stylesheet" href="assets/css/plugin/material-scrolltop.css">
    <link rel="stylesheet" href="assets/css/plugin/price_range_style.css">
    <link rel="stylesheet" href="assets/css/plugin/in-number.css">
    <link rel="stylesheet" href="assets/css/plugin/venobox.min.css">

    <!-- Main Style CSS File -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/auth-modern.css">
    <link rel="stylesheet" href="assets/css/responsive-custom.css">
</head>

<body class="auth-page">

<?php include_once('includes/header.php');?>
    
   <!-- ::::::  Start  Breadcrumb Section  ::::::  -->
    <div class="page-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <ul class="page-breadcrumb__menu">
                        <li class="page-breadcrumb__nav"><a href="index.php">Home</a></li>
                        <li class="page-breadcrumb__nav active">Forgot Password</li>
                    </ul>
                </div>
            </div>
        </div>
    </div> <!-- ::::::  End  Breadcrumb Section  ::::::  -->

    <!-- ::::::  Start  Main Container Section  ::::::  -->
    <main id="main-container" class="main-container">
        <div class="container">
            <div class="row">
               <div class="col-12">
                <!-- forgot password area start -->
                <div class="login-register-area auth-modern">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-6 col-md-8 col-sm-10 ml-auto mr-auto">
                                <div class="login-register-wrapper" style="padding: 40px 30px;">
                                    
                                    <!-- Step 1: Enter Mobile Number -->
                                    <div id="step1" class="forgot-step">
                                        <div class="text-center mb-4">
                                            <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center;">
                                                <i class="fas fa-lock" style="font-size: 35px; color: white;"></i>
                                            </div>
                                            <h3 style="color: #333; margin-bottom: 10px;">Forgot Password?</h3>
                                            <p style="color: #666; font-size: 14px;">Enter your registered mobile number to receive OTP</p>
                                        </div>
                                        
                                        <form id="sendOtpForm" onsubmit="return false;">
                                            <p id="step1Message" class="form-message text-center" style="font-size: 14px; min-height: 20px;"></p>
                                            <div class="form-box__single-group input-with-icon">
                                                <i class="fas fa-phone input-icon"></i>
                                                <input type="text" id="forgotMobile" maxlength="10" pattern="[0-9]{10}" placeholder="Enter Mobile Number" required>
                                            </div>
                                            <button type="button" id="sendOtpBtn" class="btn btn--box btn--medium btn--blue btn--uppercase btn--weight w-100" onclick="sendForgotOTP()">
                                                Send OTP
                                            </button>
                                        </form>
                                        
                                        <div class="text-center mt-4">
                                            <p style="color: #666; font-size: 14px;">
                                                Remember your password? <a href="login.php" style="color: #667eea; font-weight: 500;">Login here</a>
                                            </p>
                                        </div>
                                    </div>
                                    
                                    <!-- Step 2: Verify OTP & Reset Password -->
                                    <div id="step2" class="forgot-step" style="display: none;">
                                        <div class="text-center mb-4">
                                            <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center;">
                                                <i class="fas fa-shield-alt" style="font-size: 35px; color: white;"></i>
                                            </div>
                                            <h3 style="color: #333; margin-bottom: 10px;">Verify OTP</h3>
                                            <p style="color: #666; font-size: 14px;">Enter the OTP sent to <span id="displayMobile" style="font-weight: 600;"></span></p>
                                        </div>
                                        
                                        <form id="resetPasswordForm" onsubmit="return false;">
                                            <p id="step2Message" class="form-message text-center" style="font-size: 14px; min-height: 20px;"></p>
                                            
                                            <div class="form-box__single-group">
                                                <label style="font-weight: 500; color: #333; margin-bottom: 8px; display: block;">Enter 6-digit OTP</label>
                                                <input type="text" id="forgotOtp" class="form-control" maxlength="6" pattern="[0-9]{6}" 
                                                       style="text-align: center; font-size: 20px; letter-spacing: 8px; font-weight: 600;" 
                                                       placeholder="------" required>
                                            </div>
                                            
                                            <div class="form-box__single-group input-with-icon">
                                                <i class="fas fa-lock input-icon"></i>
                                                <input type="password" id="newPassword" placeholder="New Password" required>
                                            </div>
                                            
                                            <div class="form-box__single-group input-with-icon">
                                                <i class="fas fa-lock input-icon"></i>
                                                <input type="password" id="confirmPassword" placeholder="Confirm Password" required>
                                            </div>
                                            
                                            <button type="button" id="resetBtn" class="btn btn--box btn--medium btn--blue btn--uppercase btn--weight w-100" onclick="verifyAndReset()">
                                                Reset Password
                                            </button>
                                        </form>
                                        
                                        <div class="text-center mt-3">
                                            <p style="color: #999; font-size: 13px;">Didn't receive the code? 
                                                <a href="#" id="resendOtpLink" onclick="resendForgotOTP(); return false;" style="color: #667eea; font-weight: 500;">Resend OTP</a>
                                            </p>
                                            <p id="timerDisplay" style="color: #667eea; font-weight: 500; font-size: 14px;"></p>
                                        </div>
                                        
                                        <div class="text-center mt-3">
                                            <a href="#" onclick="goBackToStep1(); return false;" style="color: #666; font-size: 13px;">
                                                <i class="fas fa-arrow-left"></i> Change mobile number
                                            </a>
                                        </div>
                                    </div>
                                    
                                    <!-- Step 3: Success -->
                                    <div id="step3" class="forgot-step" style="display: none;">
                                        <div class="text-center">
                                            <div style="width: 100px; height: 100px; background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); border-radius: 50%; margin: 0 auto 25px; display: flex; align-items: center; justify-content: center;">
                                                <i class="fas fa-check" style="font-size: 50px; color: white;"></i>
                                            </div>
                                            <h3 style="color: #333; margin-bottom: 15px;">Password Reset Successful!</h3>
                                            <p style="color: #666; font-size: 14px; margin-bottom: 25px;">Your password has been changed successfully. You can now login with your new password.</p>
                                            <a href="login.php" class="btn btn--box btn--medium btn--blue btn--uppercase btn--weight">
                                                <i class="fas fa-sign-in-alt mr-2"></i> Login Now
                                            </a>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- forgot password area end -->
               </div>
            </div>
        </div>
    </main> <!-- ::::::  End  Main Container Section  ::::::  -->

   <?php include_once('includes/footer.php');?>

    <!-- material-scrolltop button -->
    <button class="material-scrolltop" type="button"></button>
    

    <!-- ::::::::::::::All Javascripts Files here ::::::::::::::-->

    <!-- Vendor JS Files -->
    <script src="assets/js/vendor/jquery-3.5.1.min.js"></script>
    <script src="assets/js/vendor/modernizr-3.7.1.min.js"></script>
    <script src="assets/js/vendor/jquery-ui.min.js"></script>
    <script src="assets/js/vendor/bootstrap.bundle.js"></script>

    <!-- Plugins JS Files -->
    <script src="assets/js/plugin/swiper.min.js"></script>
    <script src="assets/js/plugin/jquery.countdown.min.js"></script>
    <script src="assets/js/plugin/material-scrolltop.js"></script>
    <script src="assets/js/plugin/price_range_script.js"></script>
    <script src="assets/js/plugin/in-number.js"></script>
    <script src="assets/js/plugin/jquery.elevateZoom-3.0.8.min.js"></script>
    <script src="assets/js/plugin/venobox.min.js"></script>

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <!-- <script src="assets/js/vendor/vendor.min.js"></script>
    <script src="assets/js/plugin/plugins.min.js"></script> -->

    <!-- Main js file that contents all jQuery plugins activation. -->
    <script src="assets/js/main.js"></script>
    
    <script>
    // Forgot Password OTP System
    var forgotTimer;
    var forgotTimerSeconds = 60;
    var currentMobile = '';

    function showStep1Message(msg, color) {
        var el = document.getElementById('step1Message');
        el.innerHTML = msg;
        el.style.color = color || 'red';
    }

    function showStep2Message(msg, color) {
        var el = document.getElementById('step2Message');
        el.innerHTML = msg;
        el.style.color = color || 'red';
    }

    function sendForgotOTP() {
        var mobile = document.getElementById('forgotMobile').value.trim();
        var btn = document.getElementById('sendOtpBtn');
        
        // Validate mobile number
        if(!/^[0-9]{10}$/.test(mobile)) {
            showStep1Message('Please enter a valid 10-digit mobile number', 'red');
            return;
        }
        
        currentMobile = mobile;
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending OTP...';
        showStep1Message('');
        
        $.ajax({
            url: 'send-forgot-otp.php',
            type: 'POST',
            data: { mobilenumber: mobile },
            dataType: 'json',
            success: function(response) {
                btn.disabled = false;
                btn.innerHTML = 'Send OTP';
                
                if(response.status === 'success') {
                    showStep1Message(response.message, 'green');
                    // Show step 2
                    document.getElementById('step1').style.display = 'none';
                    document.getElementById('step2').style.display = 'block';
                    document.getElementById('displayMobile').innerHTML = '+91 ' + mobile.substring(0,2) + '****' + mobile.substring(6);
                    startForgotTimer();
                } else {
                    showStep1Message(response.message, 'red');
                }
            },
            error: function() {
                btn.disabled = false;
                btn.innerHTML = 'Send OTP';
                showStep1Message('Network error. Please try again.', 'red');
            }
        });
    }

    function verifyAndReset() {
        var otp = document.getElementById('forgotOtp').value.trim();
        var newPassword = document.getElementById('newPassword').value;
        var confirmPassword = document.getElementById('confirmPassword').value;
        var btn = document.getElementById('resetBtn');
        
        // Validate OTP
        if(!/^[0-9]{6}$/.test(otp)) {
            showStep2Message('Please enter a valid 6-digit OTP', 'red');
            return;
        }
        
        // Validate passwords
        if(!newPassword || newPassword.length < 4) {
            showStep2Message('Password must be at least 4 characters', 'red');
            return;
        }
        
        if(newPassword !== confirmPassword) {
            showStep2Message('Passwords do not match', 'red');
            return;
        }
        
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Resetting...';
        showStep2Message('');
        
        $.ajax({
            url: 'verify-forgot-otp.php',
            type: 'POST',
            data: {
                otp: otp,
                mobilenumber: currentMobile,
                newpassword: newPassword
            },
            dataType: 'json',
            success: function(response) {
                btn.disabled = false;
                btn.innerHTML = 'Reset Password';
                
                if(response.status === 'success') {
                    clearInterval(forgotTimer);
                    // Show success step
                    document.getElementById('step2').style.display = 'none';
                    document.getElementById('step3').style.display = 'block';
                } else {
                    showStep2Message(response.message, 'red');
                }
            },
            error: function() {
                btn.disabled = false;
                btn.innerHTML = 'Reset Password';
                showStep2Message('Network error. Please try again.', 'red');
            }
        });
    }

    function resendForgotOTP() {
        if(forgotTimerSeconds > 0) {
            showStep2Message('Please wait ' + forgotTimerSeconds + ' seconds before resending', 'orange');
            return;
        }
        
        document.getElementById('resendOtpLink').innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
        
        $.ajax({
            url: 'send-forgot-otp.php',
            type: 'POST',
            data: { mobilenumber: currentMobile },
            dataType: 'json',
            success: function(response) {
                document.getElementById('resendOtpLink').innerHTML = 'Resend OTP';
                if(response.status === 'success') {
                    showStep2Message('OTP resent successfully!', 'green');
                    startForgotTimer();
                } else {
                    showStep2Message(response.message, 'red');
                }
            },
            error: function() {
                document.getElementById('resendOtpLink').innerHTML = 'Resend OTP';
                showStep2Message('Failed to resend OTP. Please try again.', 'red');
            }
        });
    }

    function goBackToStep1() {
        clearInterval(forgotTimer);
        document.getElementById('step2').style.display = 'none';
        document.getElementById('step1').style.display = 'block';
        document.getElementById('forgotOtp').value = '';
        document.getElementById('newPassword').value = '';
        document.getElementById('confirmPassword').value = '';
        showStep2Message('');
    }

    function startForgotTimer() {
        forgotTimerSeconds = 60;
        clearInterval(forgotTimer);
        updateForgotTimerDisplay();
        
        forgotTimer = setInterval(function() {
            forgotTimerSeconds--;
            updateForgotTimerDisplay();
            if(forgotTimerSeconds <= 0) {
                clearInterval(forgotTimer);
            }
        }, 1000);
    }

    function updateForgotTimerDisplay() {
        var display = document.getElementById('timerDisplay');
        if(forgotTimerSeconds > 0) {
            display.innerHTML = 'Resend available in ' + forgotTimerSeconds + 's';
        } else {
            display.innerHTML = '';
        }
    }

    // Allow Enter key to submit
    $(document).ready(function() {
        $('#forgotMobile').on('keypress', function(e) {
            if(e.which === 13) {
                sendForgotOTP();
            }
        });
        
        $('#forgotOtp, #newPassword, #confirmPassword').on('keypress', function(e) {
            if(e.which === 13) {
                verifyAndReset();
            }
        });
    });
    </script>
</body>

</html>
